// SkyBox.cpp: Implementierung der Klasse CSkyBox.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SkyBox.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CSkyBox::CSkyBox()
{
	// Init all member variables to default values
	m_SkyBoxSize = 1.0f;
	m_AnimatedWaterOffset = 1.0f;
}

CSkyBox::~CSkyBox()
{

}

void CSkyBox::GenerateSkyBox(int iListIndex)
{
	// Generate the display list for the skybox from the class member variables
	
	// Save passed list index
	m_SkyBoxList = iListIndex;

	// Use saved list index
	glNewList(m_SkyBoxList, GL_COMPILE);
 
		// Set winding to clock-wise
		glFrontFace(GL_CW);

		// Use sky txture
		m_SkyTexture.Use();

		// Sky
		glBegin(GL_QUADS);
			// Front Face
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-m_SkyBoxSize, 0.0f,                m_SkyBoxSize);	// Bottom Left Of The Texture and Quad
			glTexCoord2f(1.0f, 0.0f); glVertex3f( m_SkyBoxSize, 0.0f,				 m_SkyBoxSize);	// Bottom Right Of The Texture and Quad
			glTexCoord2f(1.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Top Right Of The Texture and Quad
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Top Left Of The Texture and Quad
			// Back Face
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-m_SkyBoxSize, 0.0f,                -m_SkyBoxSize);// Bottom Right Of The Texture and Quad
			glTexCoord2f(1.0f, 1.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Right Of The Texture and Quad
			glTexCoord2f(0.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Left Of The Texture and Quad
			glTexCoord2f(0.0f, 0.0f); glVertex3f( m_SkyBoxSize, 0.0f,                -m_SkyBoxSize);// Bottom Left Of The Texture and Quad
			// Top Face
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Left Of The Texture and Quad
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Bottom Left Of The Texture and Quad
			glTexCoord2f(1.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Bottom Right Of The Texture and Quad
			glTexCoord2f(0.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Right Of The Texture and Quad
			// Right face
			glTexCoord2f(1.0f, 0.0f); glVertex3f( m_SkyBoxSize, 0.0f,                -m_SkyBoxSize);// Bottom Right Of The Texture and Quad
			glTexCoord2f(1.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Right Of The Texture and Quad
			glTexCoord2f(0.0f, 1.0f); glVertex3f( m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Top Left Of The Texture and Quad
			glTexCoord2f(0.0f, 0.0f); glVertex3f( m_SkyBoxSize, 0.0f,                m_SkyBoxSize);	// Bottom Left Of The Texture and Quad
			// Left Face
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-m_SkyBoxSize, 0.0f,               -m_SkyBoxSize);	// Bottom Left Of The Texture and Quad
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-m_SkyBoxSize, 0.0f,                m_SkyBoxSize);	// Bottom Right Of The Texture and Quad
			glTexCoord2f(1.0f, 1.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, m_SkyBoxSize);	// Top Right Of The Texture and Quad
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-m_SkyBoxSize, m_SkyBoxSize + 1.0f, -m_SkyBoxSize);// Top Left Of The Texture and Quad
		glEnd();

		// Use water texture
		m_WaterTexture.Use();

		// Save state (DepthMask should be restored later)
		m_WaterTexture.SaveState();

			// No Z-Buffer writes
			glDepthMask(0);

			// Water base-texture
			glBegin(GL_QUADS);
				glColor4f(0.5f, 0.6f, 0.7f, 1.0f);
				glTexCoord2f(1.0f, 0.0f); glVertex3f(m_SkyBoxSize, 0.0f, -m_SkyBoxSize);
				glColor4f(0.2f, 0.3f, 0.9f, 1.0f);
				glTexCoord2f(1.0f, 1.0f); glVertex3f(m_SkyBoxSize, 0.0f,  m_SkyBoxSize);
				glColor4f(0.8f, 0.8f, 0.7f, 1.0f);
				glTexCoord2f(0.0f, 1.0f); glVertex3f(-m_SkyBoxSize, 0.0f,  m_SkyBoxSize);
				glColor4f(0.0f, 0.6f, 0.4f, 1.0f);
				glTexCoord2f(0.0f, 0.0f); glVertex3f(-m_SkyBoxSize, 0.0f, -m_SkyBoxSize);
			glEnd();
					
		// Restore state (DepthMask)
		m_WaterTexture.RestoreState();
	
	glEndList();
}

void CSkyBox::DrawSkyBox()
{
	// Save state
	glPushAttrib(GL_FOG_BIT | GL_LIGHTING_BIT);

		// Disable fog and lighting for the sky
		glDisable(GL_FOG);
		glDisable(GL_LIGHTING);

		// Call display list for the skybox
		glCallList(m_SkyBoxList);
		
		// After calling the display list, the current texture is the
		// water texture

		// Set up a black fog for the water
		glEnable(GL_FOG);			
		glFogf(GL_FOG_DENSITY, 0.5f);
		glFogi(GL_FOG_MODE, GL_EXP);
		glFogf(GL_FOG_START, 6.0f);
		GLfloat FogColor[] = { 0.0f, 0.0f, 0.0f, 1.0f };
		glFogfv(GL_FOG_COLOR, FogColor);

		// Save state
		m_WaterTexture.SaveState();

			// Enable lightmapping
			m_WaterTexture.Lightmap();

			// Set correct texture parameters for moving water
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S, GL_REPEAT);
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T, GL_REPEAT);

			// Water
			glBegin(GL_QUADS);
				glTexCoord2f(1.0f + m_AnimatedWaterOffset, 0.0f + m_AnimatedWaterOffset);
				glVertex3f(m_SkyBoxSize, 0.0f, -m_SkyBoxSize);
				glTexCoord2f(1.0f + m_AnimatedWaterOffset, 1.0f + m_AnimatedWaterOffset);
				glVertex3f(m_SkyBoxSize, 0.0f,  m_SkyBoxSize);
				glTexCoord2f(0.0f + m_AnimatedWaterOffset, 1.0f + m_AnimatedWaterOffset);
				glVertex3f(-m_SkyBoxSize, 0.0f,  m_SkyBoxSize);
				glTexCoord2f(0.0f + m_AnimatedWaterOffset, 0.0f + m_AnimatedWaterOffset); 
				glVertex3f(-m_SkyBoxSize, 0.0f, -m_SkyBoxSize);
			glEnd();

			// Check for animation offset maximum
			if (m_AnimatedWaterOffset > 1.0f)
				m_AnimatedWaterOffset = 0.0f;
						
			// Increment texture animation offset
			m_AnimatedWaterOffset += 0.00025f;

		// Restore texture & blending bit
		m_WaterTexture.RestoreState();

	// Restore fog and lighting
	glPopAttrib();

}
